<!DOCTYPE html>
<html lang="en">
  <head>
    <title>The Gentlemen Lounge | HOME</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <link href="https://fonts.googleapis.com/css?family=Poppins:300,400,500,600,700" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Barlow+Condensed:500,600,700&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="css/open-iconic-bootstrap.min.css">
    <link rel="stylesheet" href="css/animate.css">
    
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="stylesheet" href="css/owl.theme.default.min.css">
    <link rel="stylesheet" href="css/magnific-popup.css">

    <link rel="stylesheet" href="css/aos.css">

    <link rel="stylesheet" href="css/ionicons.min.css">

    <link rel="stylesheet" href="css/bootstrap-datepicker.css">
    <link rel="stylesheet" href="css/jquery.timepicker.css">

    
    <link rel="stylesheet" href="css/flaticon.css">
    <link rel="stylesheet" href="css/icomoon.css">
    <link rel="stylesheet" href="css/style.css">
  </head>
  <body>
	<?php include 'header.php'?> 
    <!-- END nav -->

    <section class="hero-wrap js-fullheight" style="background-image: url(img/bg_7.jpg);" data-stellar-background-ratio="0.5">
      <div class="overlay"></div>
      <div class="container">
        <div class="row no-gutters slider-text js-fullheight justify-content-center align-items-center">
          <div class="col-lg-12 ftco-animate d-flex align-items-center">
          	<div class="text text-center">
          		<span class="subheading">Welcome to Haircare</span>
		  				<h1 class="mb-4">We are professional care for your hair</h1>
		  				<p><a href="#apt" class="btn btn-primary btn-outline-primary px-4 py-2">Book now</a></p>
							</div>
            </div>
          </div>
        </div>
      </div>
    </section>
		
		<section class="ftco-section ftco-no-pt ftco-no-pb">
			<div class="container-fluid px-0">
				<div class="row no-gutters">
					<div class="col-md text-center d-flex align-items-stretch">
						<div class="services-wrap d-flex align-items-center img" style="background-image: url(img/img\ \(16\).jpeg);">
							<div class="text">
								<h3>For Men</h3>
								<p><a href="services.php#price" class="btn-custom">See pricing <span class="ion-ios-arrow-round-forward"></span></a></p>
							</div>
						</div>
					</div>
					<div class="col-md-6 text-center d-flex align-items-stretch">
						<div class="text-about py-5 px-4">
							<h1 class="logo">
								<a href="#"><img src="images/logo.png" style="width:150px"> </a>
							</h1>
							<h2>Welcome to our Salon</h2>
							<p>Welcome to our salon! We are a team of highly skilled and experienced beauty professionals dedicated to providing our clients with the best possible salon experience.</p>
							<p class="mt-3"><a href="about.php" class="btn btn-primary btn-outline-primary">Read more</a></p>
						</div>
					</div>
					<!--<div class="col-md text-center d-flex align-items-stretch">-->
					<!--	<div class="services-wrap d-flex align-items-center img" style="background-image: url(img/img\ \(26\).jpeg);">-->
					<!--		<div class="text">-->
					<!--			<h3>For Women</h3>-->
					<!--			<p><a href="services.php#price" class="btn-custom">See pricing <span class="ion-ios-arrow-round-forward"></span></a></p>-->
					<!--		</div>-->
					<!--	</div>-->
					<!--</div>-->
				</div>
			</div>
		</section>
    
    <section class="services-section ftco-section">
      <div class="container">
      	<div class="row justify-content-center pb-3">
          <div class="col-md-10 heading-section text-center ftco-animate">
          	<span class="subheading">Services</span>
            <h2 class="mb-4">Services Menu</h2>
            <p>Our services include haircuts, shaves, beard trims, and more</p>
          </div>
        </div>
        <div class="row no-gutters d-flex">
          <div class="col-md-6 col-lg-3 d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services d-block text-center">
              <div class="icon"><span class="flaticon-male-hair-of-head-and-face-shapes"></span></div>
              <div class="media-body">
                <h3 class="heading mb-3">Haircut &amp; Styling</h3>
                <p> We use the latest techniques and high-quality products to ensure that you leave our salon looking and feeling your best.</p>
              </div>
            </div>    
          </div>
          <div class="col-md-6 col-lg-3 d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services d-block text-center">
              <div class="icon"><span class="flaticon-beard"></span></div>
              <div class="media-body">
                <h3 class="heading mb-3">Beard</h3>
                <p>We offer a range of beard grooming services to help you keep your facial hair looking its best.</p>
              </div>
            </div>      
          </div>
          <div class="col-md-6 col-lg-3 d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services d-block text-center">
              <div class="icon"><span class="flaticon-beauty-products"></span></div>
              <div class="media-body">
                <h3 class="heading mb-3">Styling</h3>
                <p>Our makeup artists are skilled in creating a wide range of looks to suit your unique style and preferences.</p>
              </div>
            </div>      
          </div>
          <div class="col-md-6 col-lg-3 d-flex align-self-stretch ftco-animate">
            <div class="media block-6 services d-block text-center">
              <div class="icon"><span class="flaticon-healthy-lifestyle-logo"></span></div>
              <div class="media-body">
                <h3 class="heading mb-3">Body Treatment</h3>
                <p>Our body treatment services are designed to help you relax, rejuvenate, and pamper yourself.</p>
              </div>
            </div>      
          </div>
        </div>
      </div>
    </section>

    <section class="ftco-section ftco-booking bg-light" id="apt">
    	<div class="container ftco-relative">
    		<div class="row justify-content-center pb-3">
          <div class="col-md-10 heading-section text-center ftco-animate">
          	<span class="subheading">Booking</span>
            <h2 class="mb-4">Make an Appointment</h2>
            <p>Our online booking system is simple and convenient, allowing you to book an appointment anytime, anywhere.</p>
          </div>
        </div>
        <h3 class="vr">Call Us: 0334-4765666</h3>
    		<div class="row justify-content-center">
    			<div class="col-md-10 ftco-animate">
    				<form action="email/simple.php" class="appointment-form">
	            <div class="row">
	              <div class="col-sm-6">
	                <div class="form-group">
			              <input type="text" name="name" class="form-control" id="appointment_name" placeholder="Name">
			            </div>
	              </div>
	              <div class="col-sm-6">
	                <div class="form-group">
			              <input type="text" name="email" class="form-control" id="appointment_email" placeholder="Email">
			            </div>
	              </div>
	              <div class="col-sm-6">
	                <div class="form-group">
	                  <input type="text" name="date" class="form-control appointment_date" placeholder="Date">
	                </div>    
	              </div>
	              <div class="col-sm-6">
	                <div class="form-group">
	                  <input type="text" name="time" class="form-control appointment_time" placeholder="Time">
	                </div>
	              </div>
	              <div class="col-sm-6">
	                <div class="form-group">
			              <div class="select-wrap">
                      <div class="icon"><span class="ion-ios-arrow-down"></span></div>
                      <select name="services" id="" class="form-control">
                      	<option value="Professional Makeup">Professional Makeup</option>
                        <option value="Manicure Pedicure">Manicure Pedicure</option>
                        <option value="Body Treatment">Body Treatment</option>
                        <option value="Haircut &amp; Coloring">Haircut &amp; Coloring</option>
                      </select>
                    </div>
			            </div>
	              </div>
	              <div class="col-sm-6">
	                <div class="form-group">
	                  <input type="text" name="phone" class="form-control" id="phone" placeholder="Phone">
	                </div>
	              </div>
	              <div class="col-md-12">
	              	<div class="form-group">
		                <textarea name="masg" id="" cols="30" rows="7" class="form-control" placeholder="Message"></textarea>
		              </div>
	              </div>
		          </div>
		          <div class="form-group">
	              <input type="submit" value="Make an Appointment" class="btn btn-primary">
	            </div>
	          </form>
    			</div>
    		</div>
    	</div>
    </section>


    <!--<section class="ftco-section ftco-team">-->
    <!--	<div class="container-fluid px-md-5">-->
    <!--		<div class="row justify-content-center pb-3">-->
    <!--      <div class="col-md-10 heading-section text-center ftco-animate">-->
    <!--      	<span class="subheading">Artistic Director</span>-->
    <!--        <h2 class="mb-4">Our Team</h2>-->
    <!--        <p>Our team is made up of experienced hairstylists, makeup artists,<br> beard groomers, and body treatment specialists.</p>-->
    <!--      </div>-->
    <!--    </div>-->
    <!--    <div class="row">-->
    <!--    	<div class="col-md-12 ftco-animate">-->
    <!--    		<div class="carousel-team owl-carousel">-->
    <!--    			<div class="item">-->
		  <!--      		<a href="#" class="team text-center">-->
		  <!--      			<div class="img" style="background-image: url(images/stylist-1.jpg);"></div>-->
		  <!--      			<h2>Danica Lewis</h2>-->
		  <!--      			<span class="position">Hair Stylist</span>-->
		  <!--      		</a>-->
    <!--    			</div>-->
    <!--    			<div class="item">-->
	   <!--     			<a href="#" class="team text-center">-->
		  <!--      			<div class="img" style="background-image: url(images/stylist-2.jpg);"></div>-->
		  <!--      			<h2>Nicole Simon</h2>-->
		  <!--      			<span class="position">Nail Master</span>-->
		  <!--      		</a>-->
	   <!--     		</div>-->
	   <!--     		<div class="item">-->
	   <!--     			<a href="#" class="team text-center">-->
		  <!--      			<div class="img" style="background-image: url(images/stylist-3.jpg);"></div>-->
		  <!--      			<h2>Cloe Meyer</h2>-->
		  <!--      			<span class="position">Director</span>-->
		  <!--      		</a>-->
	   <!--     		</div>-->
	   <!--     		<div class="item">-->
	   <!--     			<a href="#" class="team text-center">-->
		  <!--      			<div class="img" style="background-image: url(images/stylist-4.jpg);"></div>-->
		  <!--      			<h2>Rachel Clinton</h2>-->
		  <!--      			<span class="position">Hair Stylist</span>-->
		  <!--      		</a>-->
	   <!--     		</div>-->
	   <!--     		<div class="item">-->
	   <!--     			<a href="#" class="team text-center">-->
		  <!--      			<div class="img" style="background-image: url(images/stylist-5.jpg);"></div>-->
		  <!--      			<h2>Dave Buff</h2>-->
		  <!--      			<span class="position">Barber</span>-->
		  <!--      		</a>-->
	   <!--     		</div>-->
    <!--    		</div>-->
    <!--    	</div>-->
    <!--    </div>-->
    <!--	</div>-->
    <!--</section>-->

    <section class="ftco-section ftco-no-pt ftco-no-pb">
    	<div class="container">
    		<div class="row no-gutters justify-content-center mb-5 pb-2">
          <div class="col-md-6 text-center heading-section ftco-animate">
          	<span class="subheading">Gallery</span>
            <h2 class="mb-4">Our gallery</h2>
            <p> Our gallery features a range of services we offer, including haircuts, beard grooming, makeup, and body treatments.</p>
          </div>
        </div>
    	</div>
			<div class="container-fluid p-0">
    		<div class="row no-gutters">
    			<div class="col-md-6 col-lg-3 ftco-animate">
    				<div class="project">
	    				<img src="gallery/1 (1).jpeg" class="img-fluid" alt="Colorlib Template">
	    				<div class="text">
	    					<span>Stylist</span>
	    					<h3><a href="project.html">Hair Wash</a></h3>
	    				</div>
	    				<a href="gallery/1  (1).jpeg" class="icon image-popup d-flex justify-content-center align-items-center">
	    					<span class="icon-expand"></span>
	    				</a>
    				</div>
    			</div>
    			<div class="col-md-6 col-lg-3 ftco-animate">
    				<div class="project">
	    				<img src="gallery/1 (2).jpeg" class="img-fluid" alt="Colorlib Template">
	    				<div class="text">
	    					<span>Hair</span>
	    					<h3><a href="project.html">Haircut</a></h3>
	    				</div>
	    				<a href="gallery/1 (2).jpeg" class="icon image-popup d-flex justify-content-center align-items-center">
	    					<span class="icon-expand"></span>
	    				</a>
    				</div>
    			</div>
    				<div class="col-md-6 col-lg-3 ftco-animate">
    				<div class="project">
	    				<img src="gallery/1 (5).jpeg" class="img-fluid" alt="Colorlib Template">
	    				<div class="text">
	    					<span>Hair</span>
	    					<h3><a href="project.html">Styling</a></h3>
	    				</div>
	    				<a href="gallery/1 (5).jpeg" class="icon image-popup d-flex justify-content-center align-items-center">
	    					<span class="icon-expand"></span>
	    				</a>
    				</div>
    			</div>
    		
    			<div class="col-md-6 col-lg-3 ftco-animate">
    				<div class="project">
	    				<img src="gallery/1 (4).jpeg" class="img-fluid" alt="Colorlib Template">
	    				<div class="text">
	    					<span>face</span>
	    					<h3><a href="project.html">Facial</a></h3>
	    				</div>
	    				<a href="gallery/1 (4).jpeg" class="icon image-popup d-flex justify-content-center align-items-center">
	    					<span class="icon-expand"></span>
	    				</a>
    				</div>
    			</div>
    			<div class="col-md-6 col-lg-3 ftco-animate">
    				<div class="project">
	    				<img src="gallery/1 (3).jpeg" class="img-fluid" alt="Colorlib Template">
	    				<div class="text">
	    					<span>Face</span>
	    					<h3><a href="project.html">Treatment</a></h3>
	    				</div>
	    				<a href="gallery/1 (3).jpeg" class="icon image-popup d-flex justify-content-center align-items-center">
	    					<span class="icon-expand"></span>
	    				</a>
    				</div>
    			</div>
    			<div class="col-md-6 col-lg-3 ftco-animate">
    				<div class="project">
	    				<img src="gallery/1 (6).jpeg" class="img-fluid" alt="Colorlib Template">
	    				<div class="text">
	    					<span>Fashion</span>
	    					<h3><a href="project.html">Model</a></h3>
	    				</div>
	    				<a href="gallery/1 (6).jpeg" class="icon image-popup d-flex justify-content-center align-items-center">
	    					<span class="icon-expand"></span>
	    				</a>
    				</div>
    			</div>
    			<div class="col-md-6 col-lg-3 ftco-animate">
    				<div class="project">
	    				<img src="gallery/1 (7).jpeg" class="img-fluid" alt="Colorlib Template">
	    				<div class="text">
	    					<span>Luxury</span>
	    					<h3><a href="project.html">Salon Chairs</a></h3>
	    				</div>
	    				<a href="gallery/1 (7).jpeg" class="icon image-popup d-flex justify-content-center align-items-center">
	    					<span class="icon-expand"></span>
	    				</a>
    				</div>
    			</div>
    			<div class="col-md-6 col-lg-3 ftco-animate">
    				<div class="project">
	    				<img src="gallery/1 (8).jpeg" class="img-fluid" alt="Colorlib Template">
	    				<div class="text">
	    					<span>Area</span>
	    					<h3><a href="project.html">Corridor</a></h3>
	    				</div>
	    				<a href="gallery/1 (8).jpeg" class="icon image-popup d-flex justify-content-center align-items-center">
	    					<span class="icon-expand"></span>
	    				</a>
    				</div>
    			</div>
    		</div>
		</section>
		
		<!--<section class="ftco-section ftco-pricing">-->
		<!--	<div class="container">-->
		<!--		<div class="row justify-content-center pb-3">-->
  <!--        <div class="col-md-10 heading-section text-center ftco-animate">-->
  <!--        	<span class="subheading">Pricing</span>-->
  <!--          <h2 class="mb-4">Our Prices</h2>-->
  <!--          <p>We are committed to providing high-quality grooming services at affordable prices.</p>-->
  <!--        </div>-->
  <!--      </div>-->
  <!--      <div class="row">-->
  <!--      	<div class="col-md-3 ftco-animate">-->
  <!--      		<div class="pricing-entry pb-5 text-center">-->
  <!--      			<div>-->
	 <!--       			<h3 class="mb-4">Hair Style</h3>-->
	 <!--       			<p><span class="price">$50.00</span> <span class="per">/ session</span></p>-->
	 <!--       		</div>-->
  <!--      			<ul>-->
  <!--      				<li>Hair Dryer</li>-->
		<!--						<li>Hair Coloring</li>-->
		<!--						<li>Hair Cut</li>-->
		<!--						<li>Hair Dresser</li>-->
		<!--						<li>Hair Spa</li>-->
  <!--      			</ul>-->
  <!--      			<p class="button text-center"><a href="#" class="btn btn-primary px-4 py-3">Get Offer</a></p>-->
  <!--      		</div>-->
  <!--      	</div>-->
  <!--      	<div class="col-md-3 ftco-animate">-->
  <!--      		<div class="pricing-entry pb-5 text-center">-->
  <!--      			<div>-->
	 <!--       			<h3 class="mb-4">Manicure Pedicure</h3>-->
	 <!--       			<p><span class="price">$34.50</span> <span class="per">/ session</span></p>-->
	 <!--       		</div>-->
  <!--      			<ul>-->
  <!--      				<li>Manicure</li>-->
		<!--						<li>Pedicure</li>-->
		<!--						<li>Coloring</li>-->
		<!--						<li>Nails</li>-->
		<!--						<li>Nail Cut</li>-->
  <!--      			</ul>-->
  <!--      			<p class="button text-center"><a href="#" class="btn btn-primary px-4 py-3">Get Offer</a></p>-->
  <!--      		</div>-->
  <!--      	</div>-->
  <!--      	<div class="col-md-3 ftco-animate">-->
  <!--      		<div class="pricing-entry active pb-5 text-center">-->
  <!--      			<div>-->
	 <!--       			<h3 class="mb-4">Styling</h3>-->
	 <!--       			<p><span class="price">$54.50</span> <span class="per">/ session</span></p>-->
	 <!--       		</div>-->
  <!--      			<ul>-->
  <!--      				<li>Makeup</li>-->
		<!--						<li>Professional Makeup</li>-->
		<!--						<li>Blush On</li>-->
		<!--						<li>Facial Massage</li>-->
		<!--						<li>Facial Spa</li>-->
  <!--      			</ul>-->
  <!--      			<p class="button text-center"><a href="#" class="btn btn-primary px-4 py-3">Get Offer</a></p>-->
  <!--      		</div>-->
  <!--      	</div>-->
  <!--      	<div class="col-md-3 ftco-animate">-->
  <!--      		<div class="pricing-entry pb-5 text-center">-->
  <!--      			<div>-->
	 <!--       			<h3 class="mb-4">Body Treatment</h3>-->
	 <!--       			<p><span class="price">$89.50</span> <span class="per">/ session</span></p>-->
	 <!--       		</div>-->
  <!--      			<ul>-->
  <!--      				<li>Massage</li>-->
		<!--						<li>Spa</li>-->
		<!--						<li>Foot Spa</li>-->
		<!--						<li>Body Spa</li>-->
		<!--						<li>Relaxing</li>-->
  <!--      			</ul>-->
  <!--      			<p class="button text-center"><a href="#" class="btn btn-primary px-4 py-3">Get Offer</a></p>-->
  <!--      		</div>-->
  <!--      	</div>-->
  <!--      </div>-->
		<!--	</div>-->
		<!--</section>-->

		<section class="testimony-section bg-light">
      <div class="container">
        <div class="row ftco-animate justify-content-center">
        	<div class="col-md-6 col-lg-5 d-flex">
        		<div class="testimony-img" style="background-image: url(img/img\ \(16\).jpeg);"></div>
        	</div>
          <div class="col-md-6 col-lg-7 py-5 pl-md-5">
          	<div class="py-md-5">
	          	<div class="heading-section ftco-animate">
	          		<span class="subheading">Testimony</span>
			          <h2 class="mb-0">Happy Customer</h2>
			        </div>
	            <div class="carousel-testimony owl-carousel ftco-animate">
	              <!-- <div class="item">
	                <div class="testimony-wrap pb-4">
	                  <div class="text">
	                    <p class="mb-4">I had a fantastic experience at this salon. The staff was professional, friendly, and knowledgeable.</p>
	                  </div>
	                  <div class="d-flex">
		                  <div class="user-img" style="background-image: url(images/stylist-1.jpg)">
		                  </div>
		                  <div class="pos ml-3">
		                  	<p class="name">Shahid</p>
		                    <span class="position">Businessman</span>
		                  </div>
		                </div>
	                </div>
	              </div> -->
	              <div class="item">
	                <div class="testimony-wrap pb-4">
	                  <div class="text">
	                    <p class="mb-4">They listened to my needs and delivered exactly what I wanted.</p>
	                  </div>
	                  <div class="d-flex">
		                  <div class="user-img" style="background-image: url(https://images.unsplash.com/photo-1655027598076-fbd00a9de5cd?w=500&auto=format&fit=crop&q=60&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxzZWFyY2h8M3x8cGFraXN0YW5pJTIwbWFufGVufDB8fDB8fHww)">
		                  </div>
		                  <div class="pos ml-3">
		                  	<p class="name">Shahid</p>
		                    <span class="position">Businessman</span>
		                  </div>
		                </div>
	                </div>
	              </div>
	              <div class="item">
	                <div class="testimony-wrap pb-4">
	                  <div class="text">
	                    <p class="mb-4">I highly recommend this salon to anyone looking for high-quality grooming services.</p>
	                  </div>
	                  <div class="d-flex">
		                  <div class="user-img" style="background-image: url(https://images.unsplash.com/photo-1633193020624-67cd4dc6efcf?w=500&auto=format&fit=crop&q=60&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxzZWFyY2h8MTB8fHBha2lzdGFuaSUyMG1hbnxlbnwwfHwwfHx8MA%3D%3D)">
		                  </div>
		                  <div class="pos ml-3">
		                  	<p class="name">Akram</p>
		                    <span class="position">Businessman</span>
		                  </div>
		                </div>
	                </div>
	              </div>
	              <div class="item">
	                <div class="testimony-wrap pb-4">
	                  <div class="text">
	                    <p class="mb-4">I recently visited this salon for a body treatment, and it was amazing!</p>
	                  </div>
	                  <div class="d-flex">
		                  <div class="user-img" style="background-image: url(https://plus.unsplash.com/premium_photo-1682090768709-b00ac36f72de?w=500&auto=format&fit=crop&q=60&ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxzZWFyY2h8OXx8cGFraXN0YW5pJTIwbWFufGVufDB8fDB8fHww)">
		                  </div>
		                  <div class="pos ml-3">
		                  	<p class="name">Junaid k.</p>
		                    <span class="position">Businessman</span>
		                  </div>
		                </div>
	                </div>
	              </div>
	           
	            </div>
	          </div>
          </div>
        </div>
      </div>
    </section>

	<?php include 'footer.php'?> 
   
    
  

  <!-- loader -->
  <div id="ftco-loader" class="show fullscreen"><svg class="circular" width="48px" height="48px"><circle class="path-bg" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke="#eeeeee"/><circle class="path" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke-miterlimit="10" stroke="#F96D00"/></svg></div>


  <script src="js/jquery.min.js"></script>
  <script src="js/jquery-migrate-3.0.1.min.js"></script>
  <script src="js/popper.min.js"></script>
  <script src="js/bootstrap.min.js"></script>
  <script src="js/jquery.easing.1.3.js"></script>
  <script src="js/jquery.waypoints.min.js"></script>
  <script src="js/jquery.stellar.min.js"></script>
  <script src="js/owl.carousel.min.js"></script>
  <script src="js/jquery.magnific-popup.min.js"></script>
  <script src="js/aos.js"></script>
  <script src="js/jquery.animateNumber.min.js"></script>
  <script src="js/bootstrap-datepicker.js"></script>
  <script src="js/jquery.timepicker.min.js"></script>
  <script src="js/scrollax.min.js"></script>
  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyBVWaKrjvy3MaE7SQ74_uJiULgl1JY0H2s&sensor=false"></script>
  <script src="js/google-map.js"></script>
  <script src="js/main.js"></script>
    
  </body>
</html>